<?PHP  if ( ! defined('BASEPATH')) exit('No direct script access allowed'); 
/**
* @package direct-project-innovation-initiative
* @subpackage libraries
*/ /** */

require_once APPPATH.'libraries/attachment.php';

/**
* @package direct-project-innovation-initiative
* @subpackage libraries
* @todo - separate patient document methods into a child class
*/
class XML_attachment extends Attachment{		
	//XML documents
	protected $_schema;
	protected $_parser;
	protected static $_parser_class;
		

////////////////////
// GETTERS
////////////////////
			
	function parser(){
		if(!isset($this->_parser)){	
			$parser_class = static::$_parser_class;	
			if(empty($parser_class)) 
				return $this->error->warning(get_class($this).'::$_parser_class must be defined by child classes');
			else
				$this->_parser = new $parser_class($this->binary_string);
		}
		return $this->_parser;
	}
	

//////////////////////
// SETTERS
//////////////////////

	
/////////////////////
// STATIC FUNCTIONS
/////////////////////

	public static function create($name, $binary_string, $more_values = array()){
		if(!static::matches_file($name, $binary_string)) return get_instance()->error->should_be_an_x('name of a '.humanize(get_called_class()).' file', $name);
		
		require_once APPPATH.'libraries/attachments/patient_document_attachment.php';
				
		if(Patient_document_attachment::matches_file($name, $binary_string)){
			return Patient_document_attachment::create($name, $binary_string, $more_values);
		}
		
		return new XML_attachment(array_merge(compact('name', 'binary_string'), $more_values));
	}

	public static function matches_file($name, $binary_string){
		if(!parent::matches_file($name, $binary_string)) return false;
		$extension = strtolower(pathinfo($name, PATHINFO_EXTENSION));
		return (validates_as('xml_string', $binary_string) && (!empty($binary_string) || $extension == 'xml'));
	}
	
}
?>